function normalizeText(s) {
  return String(s || '')
    .replace(/\u00A0|\u202F/g, ' ') // NBSP / narrow NBSP
    .trim();
}

function extractPriceNumber(rawText) {
  const t = normalizeText(rawText);
  if (!t) return null;

  // Match things like "12 345", "12 345 ₽", "12345", "12,345"
  const matches = t.match(/\d[\d\s.,]*/g);
  if (!matches || matches.length === 0) return null;

  // Prefer the first "reasonable" match
  for (const m of matches) {
    const num = Number(
      m
        .replace(/[^\d]/g, '') // keep digits only
        .trim()
    );
    if (Number.isFinite(num) && num > 0) return num;
  }

  return null;
}

module.exports = { extractPriceNumber };

