/**
 * Чтение строк и отправка обновлений через облачный сервер (ключ только на сервере).
 * Используется, когда задан ACCESS_SERVER_URL.
 */
function getRowValue(row, colName) {
  if (!row || !colName) return undefined;
  return row[colName];
}

async function fetchRowsFromServer(serverUrl, sheetId, sheetTabTitle, { offset = 0, limit, sortByColumn, sortOrder = 'asc' } = {}) {
  const params = new URLSearchParams({ sheetId });
  if (sheetTabTitle) params.set('sheetTabTitle', sheetTabTitle);
  if (offset) params.set('offset', String(offset));
  if (limit != null) params.set('limit', String(limit));
  if (sortByColumn) params.set('sortByColumn', sortByColumn);
  params.set('sortOrder', sortOrder);
  const url = `${serverUrl}/api/sheet/rows?${params.toString()}`;
  const res = await fetch(url);
  if (!res.ok) {
    const err = await res.json().catch(() => ({}));
    throw new Error(err.error || `Сервер ответил ${res.status}`);
  }
  const data = await res.json();
  return data.rows || [];
}

async function sendUpdateToServer(serverUrl, sheetId, sheetTabTitle, rowIndex, fields) {
  const url = `${serverUrl}/api/sheet/update`;
  const body = {
    sheetId,
    sheetTabTitle: sheetTabTitle || undefined,
    rowIndex,
    Price: fields.Price,
    PriceClub: fields.PriceClub,
    UpdatedAt: fields.UpdatedAt
  };
  const res = await fetch(url, {
    method: 'POST',
    headers: { 'Content-Type': 'application/json' },
    body: JSON.stringify(body)
  });
  if (!res.ok) {
    const err = await res.json().catch(() => ({}));
    throw new Error(err.error || `Сервер ответил ${res.status}`);
  }
}

module.exports = {
  getRowValue,
  fetchRowsFromServer,
  sendUpdateToServer
};
